/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.apps.tracker;

import filenet.vw.api.VWException;
import filenet.vw.api.VWStepElement;
import filenet.vw.api.VWWorkflowDefinition;
import filenet.vw.apps.tracker.VWTrackerApplet;
import filenet.vw.apps.tracker.images.VWImageLoader;
import filenet.vw.apps.tracker.resources.VWResource;
import filenet.vw.base.VWDebug;
import filenet.vw.idm.toolkit.VWIDMBaseFactory;
import filenet.vw.toolkit.runtime.VWTrkDataModel;
import filenet.vw.toolkit.runtime.VWTrkMap;
import filenet.vw.toolkit.runtime.VWTrkStep;
import filenet.vw.toolkit.runtime.dialog.VWAssignWorkDialog;
import filenet.vw.toolkit.runtime.dialog.VWCompleteWorkDialog;
import filenet.vw.toolkit.runtime.dialog.VWConfirmCancelChangesDialog;
import filenet.vw.toolkit.runtime.dialog.VWConfirmRefreshDialog;
import filenet.vw.toolkit.runtime.dialog.VWDeleteWorkDialog;
import filenet.vw.toolkit.runtime.dialog.VWLaunchStepProcessorDialog;
import filenet.vw.toolkit.runtime.dialog.VWLockWork;
import filenet.vw.toolkit.runtime.dialog.VWManageTrackersDialog;
import filenet.vw.toolkit.runtime.dialog.VWReturnWorkDialog;
import filenet.vw.toolkit.runtime.dialog.VWUnlockWork;
import filenet.vw.toolkit.runtime.dialog.VWUnlockWorkDialog;
import filenet.vw.toolkit.runtime.mapui.VWTrackerMapToolbar;
import filenet.vw.toolkit.runtime.mapui.VWTrackerWorkflowPane;
import filenet.vw.toolkit.runtime.property.VWTrackerProperty;
import filenet.vw.toolkit.runtime.summary.VWTrackerSummaryInfo;
import filenet.vw.toolkit.utils.VWAboutHelper;
import filenet.vw.toolkit.utils.VWBaseAppLauncherApplet;
import filenet.vw.toolkit.utils.VWBaseCore;
import filenet.vw.toolkit.utils.VWBaseLaunchableApplication;
import filenet.vw.toolkit.utils.VWHelp;
import filenet.vw.toolkit.utils.VWSessionInfo;
import filenet.vw.toolkit.utils.VWSplashWindow;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.dialog.VWModalDialog;
import filenet.vw.toolkit.utils.event.IVWPropertyChangeListener;
import filenet.vw.toolkit.utils.event.IVWPropertyChangeSource;
import filenet.vw.toolkit.utils.event.IVWToolbarActionListener;
import filenet.vw.toolkit.utils.event.VWPropertyChangeEvent;
import filenet.vw.toolkit.utils.event.VWPropertyChangeNotifier;
import filenet.vw.toolkit.utils.event.VWToolbarActionEvent;
import filenet.vw.toolkit.utils.event.VWToolbarActionNotifier;
import filenet.vw.toolkit.utils.event.VWToolbarMouseAdapter;
import filenet.vw.toolkit.utils.mapui.VWBaseMapToolbar;
import filenet.vw.toolkit.utils.wfdefinition.VWDefaultSessionProxy;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.EventListener;
import java.util.Locale;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JApplet;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.RepaintManager;
import javax.swing.ToolTipManager;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;

public class VWTrackerCore
extends VWBaseCore
implements ItemListener,
WindowListener,
IVWPropertyChangeListener,
IVWToolbarActionListener {
    private VWTrkDataModel m_trackerDataModel = null;
    private VWSplashWindow m_splashWindow = null;
    private Thread m_initThread = null;
    private boolean m_bTrackerMode = false;
    private boolean m_bIsRefreshing = false;
    private boolean m_bRefreshing = false;
    private boolean m_bPerformingTask = false;
    private RootSplitPane m_rootSplitPane = null;
    private ViewSplitPane m_viewSplitPane = null;
    private VWTrackerWorkflowPane m_trackerWorkflowPane = null;
    private VWTrackerSummaryInfo m_summaryPane = null;
    private VWTrackerProperty m_propPane = null;
    private JMenu m_fileMenu = null;
    private JMenuItem m_exitItem = null;
    private JMenu m_viewMenu = null;
    private JCheckBoxMenuItem m_viewPropertiesItem = null;
    private JCheckBoxMenuItem m_viewSummaryInformationItem = null;
    private JMenu m_toolbarMenu = null;
    private JCheckBoxMenuItem m_viewMainToolbarItem = null;
    private JCheckBoxMenuItem m_viewSubmapToolbarItem = null;
    private JCheckBoxMenuItem m_viewStatusBarItem = null;
    private JMenuItem m_refreshItem = null;
    private JMenu m_editPropertiesMenu = null;
    private JMenuItem m_lockSelectedStepsItem = null;
    private JMenuItem m_saveChangesItem = null;
    private JMenuItem m_cancelChangesItem = null;
    private JMenu m_unlockMenu = null;
    private JMenuItem m_unlockItem = null;
    private JMenuItem m_unlockSelectedItem = null;
    private JMenuItem m_unlockAllItem = null;
    private JMenu m_tasksMenu = null;
    private JMenuItem m_manageTrackersItem = null;
    private JMenuItem m_assignReassignWorkItem = null;
    private JMenuItem m_completeWorkItem = null;
    private JMenuItem m_terminateWorkItem = null;
    private JMenuItem m_launchStepProcessorItem = null;
    private JMenu m_helpMenu = null;
    private JMenuItem m_contentsIndexItem = null;
    private JMenuItem m_aboutItem = null;
    private JPanel m_statusBar = null;
    private JLabel m_msgLabel = null;
    private JCheckBox m_stepNamesCheckBox = null;
    private JCheckBox m_routeNamesCheckBox = null;
    private JCheckBox m_milestoneAttrsCheckBox = null;
    private JCheckBox m_conditionAttrsCheckBox = null;
    private JCheckBox m_collectorAttrsCheckBox = null;
    private JCheckBox m_stepStatusCheckBox = null;
    private Container m_mainContainer = null;
    private Container m_contentPane = null;
    private JRootPane m_rootPane = null;
    private JApplet m_parentApplet = null;
    private Frame m_parentFrame = null;
    private JApplet m_applet = null;
    private boolean m_bFrame = false;
    private JPanel m_mainPanel = new JPanel();
    private VWSessionInfo m_vwSessionInfo = null;
    private VWToolbarActionNotifier m_toolbarActionNotifier = null;
    private JPanel m_toolbarPanel = new JPanel();
    private JToolBar m_toolbar = new JToolBar();
    private VWToolbarMouseAdapter m_statusBarMouseListener = null;
    private VWToolbarMouseAdapter m_toolbarMouseListener = null;
    private JToolBar m_viewToolBar = new JToolBar();
    private AbstractButton m_viewPropertyBtn = null;
    private AbstractButton m_viewSummaryInfoBtn = null;
    private AbstractButton m_viewRefreshBtn = null;
    private JToolBar m_editPropToolBar = new JToolBar();
    private AbstractButton m_lockStepsBtn = null;
    private AbstractButton m_unlockStepsBtn = null;
    private AbstractButton m_unlockAllBtn = null;
    private AbstractButton m_saveAllBtn = null;
    private AbstractButton m_cancelAllBtn = null;
    private JToolBar m_taskToolBar = new JToolBar();
    private AbstractButton m_manageTrackersBtn = null;
    private AbstractButton m_assignReassignBtn = null;
    private AbstractButton m_completeWorkBtn = null;
    private AbstractButton m_terminateWorkBtn = null;
    private AbstractButton m_launchStepPropcessorBtn = null;
    private JToolBar m_helpToolBar = new JToolBar();
    private AbstractButton m_contextAndIndexBtn = null;
    private AbstractButton m_aboutBtn = null;
    private JMenuBar m_menuBar = new JMenuBar();
    private ItemListener m_viewPropertyListener = null;
    private ItemListener m_viewSummaryInfoListener = null;
    private ItemListener m_viewStepNamesListener = null;
    private ItemListener m_viewRouteNamesListener = null;
    private ItemListener m_viewStepStatusListener = null;
    private ItemListener m_viewMainToolbarListener = null;
    private ItemListener m_viewSubmapToolbarListener = null;
    private ItemListener m_viewStatusBarListener = null;
    private ItemListener m_viewMilestoneListener = null;
    private ItemListener m_viewRouteConditionListener = null;
    private ItemListener m_viewCollectorListener = null;
    private ActionListener m_viewRefreshListener = null;
    private ActionListener m_lockStepsListener = null;
    private ActionListener m_unlockWorkListener = null;
    private ActionListener m_unlockStepsListener = null;
    private ActionListener m_unlockAllListener = null;
    private ActionListener m_saveAllListener = null;
    private ActionListener m_cancelAllListener = null;
    private ActionListener m_manageTrackersListener = null;
    private ActionListener m_assignReassignListener = null;
    private ActionListener m_completeWorkListener = null;
    private ActionListener m_terminateWorkListener = null;
    private ActionListener m_launchStepPropcessorListener = null;
    private ActionListener m_contextAndIndexListener = null;
    private ActionListener m_aboutListener = null;
    private ActionListener m_exitListener = null;
    private MenuListener m_viewMenuListener = null;
    private MenuListener m_editPropertiesMenuListener = null;
    private MenuListener m_taskMenuListener = null;
    private static final int s_appWidth = 1024;
    private static final int s_appHeight = 768;
    private boolean m_bInitialized = false;
    private Object m_sync = new Object();
    private VWStepElement m_vwStepElement = null;
    private VWWorkflowDefinition m_workflowDefinition = null;
    private static final double s_defaultHSplitRatio = 0.66;
    private static final double s_defaultHSplitRatio_bidi = 0.33;
    private static final double s_defaultVSplitRatio = 0.66;
    private double m_hSplitRatio = 0.66;
    private double m_vSplitRatio = 0.66;
    private int m_vLastLoc = 0;
    private int m_hLastLoc = 0;

    protected void setSplashWindow(VWSplashWindow splashWindow) {
        this.m_splashWindow = splashWindow;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void init(VWSessionInfo sessionInfo) {
        Object wobNumber;
        Object error = null;
        Object contentPane = null;
        Object rootPane = null;
        this.m_vwSessionInfo = sessionInfo;
        this.m_mainContainer = sessionInfo.getParentContainer();
        this.m_parentApplet = sessionInfo.getParentApplet();
        if (this.m_mainContainer instanceof JFrame) {
            this.m_bFrame = true;
        } else {
            this.m_bFrame = false;
            if (this.m_mainContainer != null && this.m_mainContainer instanceof JApplet) {
                this.m_applet = (JApplet)this.m_mainContainer;
            }
        }
        RepaintManager repaintManager = RepaintManager.currentManager(this.m_mainContainer);
        if (repaintManager != null && !repaintManager.isDoubleBufferingEnabled()) {
            repaintManager.setDoubleBufferingEnabled(true);
        }
        this.m_parentFrame = VWModalDialog.getParentFrameUsingContainer(this.m_mainContainer);
        if (sessionInfo.getSession() != null) {
            try {
                Locale browserLocale = sessionInfo.getBrowserLocale();
                if (browserLocale != null) {
                    sessionInfo.getSession().setClientLocale(browserLocale);
                }
            }
            catch (Exception ex) {
                VWDebug.logException(ex);
            }
            VWDefaultSessionProxy.setSession(sessionInfo.getSession());
        }
        ToolTipManager.sharedInstance().setDismissDelay(100000);
        try {
            String queueName = sessionInfo.getProperty("queueName");
            wobNumber = sessionInfo.getProperty("wobNumber");
            this.m_trackerDataModel = new VWTrkDataModel(this.m_parentFrame, sessionInfo, queueName, (String)wobNumber);
            this.m_trackerDataModel.setPreferredTrackerMode(sessionInfo.getTrackerMode());
        }
        catch (Exception ex) {
            this.failedInitData();
        }
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException ie) {
            // empty catch block
        }
        VWPropertyChangeNotifier.addPropertyChangeListener(this);
        this.m_toolbarActionNotifier = new VWToolbarActionNotifier();
        this.m_toolbarActionNotifier.addToolbarActionListener(this);
        if (this.m_mainContainer instanceof JFrame) {
            this.m_bFrame = true;
            this.m_contentPane = ((JFrame)this.m_mainContainer).getContentPane();
            this.m_rootPane = ((JFrame)this.m_mainContainer).getRootPane();
        } else {
            this.m_bFrame = false;
            if (this.m_mainContainer != null && this.m_mainContainer instanceof JApplet) {
                this.m_applet = (JApplet)this.m_mainContainer;
                this.m_contentPane = this.m_applet.getContentPane();
                this.m_rootPane = this.m_applet.getRootPane();
            }
        }
        this.m_contentPane.setLayout(new BorderLayout());
        this.m_contentPane.add((Component)this.m_mainPanel, "Center");
        this.m_bTrackerMode = this.m_trackerDataModel.isTracker();
        super.init(sessionInfo);
        this.initDisplay();
        int initState = 0;
        wobNumber = this.m_sync;
        synchronized (wobNumber) {
            initState = this.m_trackerDataModel.getInitState();
        }
        if (initState == 7) {
            this.failedInitData();
        } else {
            if (this.m_bInitialized) {
                return;
            }
            this.initApplicationState();
            this.initHideShowMapToolbar();
            this.m_bInitialized = true;
            if (this.m_rootSplitPane != null) {
                this.m_rootSplitPane.setInitialized(true);
            }
            if (this.m_viewSplitPane != null) {
                this.m_viewSplitPane.setInitialized(true);
            }
            int[] stepIds = new int[]{this.m_trackerDataModel.getInitialStepId()};
            int mapId = this.m_trackerDataModel.getInitialMapId();
            if (stepIds[0] != -1) {
                this.m_trackerWorkflowPane.selectSteps(stepIds);
            } else {
                this.m_trackerWorkflowPane.selectLaunchStep();
                if (this.m_bTrackerMode) {
                    this.m_propPane.showWorkflowPropertyPane();
                }
            }
            this.updatePropPaneViewStatus();
            this.updateSummaryInfoPaneViewStatus();
        }
        this.displayInitMessages(null, null);
        super.performInitialRefresh();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initDisplay() {
        boolean bInitialized = false;
        Object object = this.m_sync;
        synchronized (object) {
            int state = this.m_trackerDataModel.getInitState();
            while (state != 7) {
                state = this.m_trackerDataModel.getInitState();
                String[] msgs = this.m_trackerDataModel.getInitMsgStrings();
                this.displayInitMessages(msgs[0], null);
                if ((this.m_bTrackerMode || state > 1) && !bInitialized) {
                    bInitialized = true;
                    if (!this.m_bTrackerMode) {
                        this.m_bTrackerMode = this.m_trackerDataModel.isTracker();
                    }
                    this.initApplicationPane();
                    this.initListeners();
                    this.initMenuBar(this.m_menuBar);
                    this.m_rootPane.setJMenuBar(this.m_menuBar);
                    this.initToolBars();
                    this.initStatusBar();
                    this.m_contentPane.add("First", this.m_toolbarPanel);
                    this.m_mainContainer.invalidate();
                    this.m_mainContainer.validate();
                    this.m_mainContainer.repaint();
                }
                if (state != 6) continue;
                break;
            }
            if (state == 6) {
                this.displayInitMessages(VWResource.s_initializingDisplay, null);
                this.initData();
            }
        }
    }

    private void failedInitData() {
        try {
            String[] msgs = this.m_trackerDataModel.getInitMsgStrings();
            String errorMsg = null;
            this.displayInitMessages(msgs[0], null);
            if (msgs.length > 0 && msgs[0] != null) {
                errorMsg = msgs[0];
                if (msgs.length > 1 && msgs[1] != null) {
                    errorMsg = errorMsg + "\n" + msgs[1];
                }
            } else {
                errorMsg = filenet.vw.toolkit.runtime.resources.VWResource.s_trackerDataFailedToInitialize;
            }
            JOptionPane.showMessageDialog(null, errorMsg, VWIDMBaseFactory.instance().getVWString(6).toString(), 0, null);
            if (this.m_splashWindow != null) {
                this.m_splashWindow.setVisible(false);
            }
            if (this.m_mainContainer instanceof JFrame) {
                this.exitApplication();
            } else {
                this.doExit();
                if (this.m_parentApplet != null && this.m_parentApplet.isActive() && this.m_parentApplet instanceof VWTrackerApplet) {
                    ((VWTrackerApplet)this.m_parentApplet).abort();
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void displayInitMessages(String msg, String subMsg) {
        if (this.m_applet != null) {
            if (msg != null) {
                this.m_applet.showStatus(msg);
            } else {
                this.m_applet.showStatus("");
            }
        }
        if (this.m_splashWindow != null) {
            this.m_splashWindow.setStatus(msg, subMsg);
        }
    }

    private void displayInitMessages(String[] msgs) {
        String msg = null;
        String subMsg = null;
        if (msgs != null) {
            if (msgs.length > 0) {
                msg = msgs[0];
            }
            if (msgs.length > 1) {
                subMsg = msgs[1];
            }
        }
        this.displayInitMessages(msg, subMsg);
    }

    private void initHideShowMapToolbar() {
        if (this.m_bInitialized) {
            return;
        }
        boolean bShow = true;
        int flag = 7;
        VWTrackerMapToolbar toolbar = this.m_trackerWorkflowPane.getTrackerMapToolbar();
        toolbar.setRendererOnMapComboBox();
        toolbar.setVisible(bShow);
        this.m_statusBarMouseListener = new VWToolbarMouseAdapter(this.m_statusBar, flag, this.m_toolbarActionNotifier);
        this.m_statusBar.addMouseListener(this.m_statusBarMouseListener);
        this.m_toolbarMouseListener = new VWToolbarMouseAdapter(this.m_toolbarPanel, flag, this.m_toolbarActionNotifier);
        this.m_toolbarPanel.addMouseListener(this.m_toolbarMouseListener);
        this.initViewMenu(bShow);
    }

    private void initViewMenu(boolean bShowMapToolbar) {
        if (bShowMapToolbar) {
            this.m_toolbarMenu = VWStringUtils.getMenuUsingString(VWResource.s_toolbarsMenu_withHK);
            if (this.m_toolbarMenu != null) {
                this.m_viewMainToolbarItem = VWStringUtils.getCheckBoxMenuItemUsingString(VWResource.s_toolbarMainMenuItem_withHK);
                if (this.m_viewMainToolbarItem != null) {
                    this.m_viewMainToolbarItem.setSelected(true);
                    this.m_viewMainToolbarItem.addItemListener(this.m_viewMainToolbarListener);
                    this.m_toolbarMenu.add(this.m_viewMainToolbarItem);
                }
                this.m_viewSubmapToolbarItem = VWStringUtils.getCheckBoxMenuItemUsingString(VWResource.s_toolbarSubmapMenuItem_withHK);
                if (this.m_viewSubmapToolbarItem != null) {
                    this.m_viewSubmapToolbarItem.setSelected(true);
                    this.m_viewSubmapToolbarItem.addItemListener(this.m_viewSubmapToolbarListener);
                    this.m_toolbarMenu.add(this.m_viewSubmapToolbarItem);
                }
                this.m_viewMenu.add(this.m_toolbarMenu);
            }
        } else {
            this.m_viewMainToolbarItem = VWStringUtils.getCheckBoxMenuItemUsingString(VWResource.s_mainToolbarMenuItem_withHK);
            if (this.m_viewMainToolbarItem != null) {
                this.m_viewMainToolbarItem.setSelected(true);
                this.m_viewMainToolbarItem.addItemListener(this.m_viewMainToolbarListener);
                this.m_viewMenu.add(this.m_viewMainToolbarItem);
            }
        }
        this.m_viewStatusBarItem = VWStringUtils.getCheckBoxMenuItemUsingString(VWResource.s_statusBarMenuItem_withHK);
        if (this.m_viewStatusBarItem != null) {
            this.m_viewStatusBarItem.setSelected(true);
            this.m_viewStatusBarItem.addItemListener(this.m_viewStatusBarListener);
            this.m_viewMenu.add(this.m_viewStatusBarItem);
        }
        this.m_viewMenu.add(new JSeparator());
        if (this.m_bTrackerMode) {
            this.m_viewPropertiesItem = VWStringUtils.getCheckBoxMenuItemUsingString(VWResource.s_propertiesMenuItem_withHK);
            this.m_viewPropertiesItem.addItemListener(this.m_viewPropertyListener);
            this.m_viewPropertiesItem.setSelected(true);
            this.m_viewMenu.add(this.m_viewPropertiesItem);
        }
        this.m_viewSummaryInformationItem = VWStringUtils.getCheckBoxMenuItemUsingString(VWResource.s_historyMenuItem_withHK);
        this.m_viewSummaryInformationItem.addItemListener(this);
        this.m_viewSummaryInformationItem.addItemListener(this.m_viewSummaryInfoListener);
        this.m_viewSummaryInformationItem.setSelected(true);
        this.m_viewMenu.add(this.m_viewSummaryInformationItem);
        this.m_viewMenu.add(new JSeparator());
        this.m_refreshItem = VWStringUtils.getMenuItemUsingString(VWResource.s_refreshMenuItem_withHK);
        this.m_refreshItem.addActionListener(this.m_viewRefreshListener);
        this.m_viewMenu.add(this.m_refreshItem);
        this.m_viewMenu.addMenuListener(this.m_viewMenuListener);
    }

    boolean isInitialized() {
        return this.m_bInitialized;
    }

    private void initApplicationPane() {
        Locale browserLocale = this.m_vwSessionInfo.getBrowserLocale();
        ComponentOrientation compOrientation = null;
        compOrientation = browserLocale != null ? ComponentOrientation.getOrientation(browserLocale) : ComponentOrientation.LEFT_TO_RIGHT;
        if (this.m_bTrackerMode) {
            this.m_rootSplitPane = new RootSplitPane(this);
        }
        this.m_viewSplitPane = new ViewSplitPane(this);
        Dimension dim = this.m_mainContainer.getSize();
        this.m_trackerWorkflowPane = new VWTrackerWorkflowPane(this.m_parentFrame, this.m_trackerDataModel, this.m_vwSessionInfo);
        this.m_trackerWorkflowPane.init(this.m_toolbarActionNotifier);
        VWBaseMapToolbar mapToolbar = this.m_trackerWorkflowPane.getMapToolbar();
        if (mapToolbar != null) {
            mapToolbar.setVisible(false);
        }
        if (this.m_bTrackerMode) {
            this.m_propPane = new VWTrackerProperty(this.m_parentFrame, this.m_trackerDataModel);
        }
        this.m_summaryPane = new VWTrackerSummaryInfo(this.m_parentFrame, this.m_trackerDataModel);
        this.m_mainPanel.setLayout(new BorderLayout());
        if (this.m_bTrackerMode) {
            this.m_mainPanel.add((Component)this.m_rootSplitPane, "Center");
            this.m_rootSplitPane.setOrientation(1);
            this.m_rootSplitPane.setPreferredSize(new Dimension(dim.width, dim.height));
            this.m_rootSplitPane.setOneTouchExpandable(true);
        } else {
            this.m_mainPanel.add((Component)this.m_viewSplitPane, "Center");
        }
        this.m_viewSplitPane.setOneTouchExpandable(true);
        this.m_viewSplitPane.setOrientation(0);
        this.m_viewSplitPane.setToolTipText(VWResource.s_slideToAdjustView);
        this.m_viewSplitPane.setBottomComponent(this.m_summaryPane);
        this.m_viewSplitPane.setTopComponent(this.m_trackerWorkflowPane);
        if (this.m_bTrackerMode) {
            if (compOrientation.isLeftToRight()) {
                this.m_hSplitRatio = 0.66;
                this.m_rootSplitPane.setRightComponent(this.m_propPane);
                this.m_rootSplitPane.setLeftComponent(this.m_viewSplitPane);
            } else {
                this.m_hSplitRatio = 0.33;
                this.m_rootSplitPane.setRightComponent(this.m_viewSplitPane);
                this.m_rootSplitPane.setLeftComponent(this.m_propPane);
            }
        }
        if (this.m_bTrackerMode) {
            this.m_trackerWorkflowPane.addItemListener(this.m_propPane);
            this.m_propPane.addItemListener(this.m_trackerWorkflowPane);
            this.m_propPane.addItemListener(this.m_summaryPane);
        }
        this.m_trackerWorkflowPane.addItemListener(this.m_summaryPane);
        if (this.m_trackerDataModel != null) {
            this.m_trackerWorkflowPane.addItemListener(this.m_trackerDataModel);
        }
        this.m_summaryPane.addItemListener(this);
    }

    private void initData() {
        if (this.m_trackerDataModel.getInitState() != 6) {
            return;
        }
        if (this.m_bTrackerMode) {
            this.m_propPane.initialize();
        }
        if (this.m_trackerWorkflowPane != null) {
            this.m_trackerWorkflowPane.initialize();
        }
        if (this.m_summaryPane != null) {
            this.m_summaryPane.initialize();
        }
    }

    private void initApplicationState() {
        if (this.m_bTrackerMode) {
            this.m_rootSplitPane.setDividerLocation(this.m_hSplitRatio);
        }
        this.m_viewSplitPane.setDividerLocation(0.66);
        if (this.m_viewPropertiesItem != null) {
            this.m_viewPropertiesItem.setSelected(true);
        }
        if (this.m_viewSummaryInformationItem != null) {
            this.m_viewSummaryInformationItem.setSelected(true);
        }
    }

    private boolean isPropertyPaneShown() {
        if (this.m_rootSplitPane == null) {
            return false;
        }
        int location = this.m_rootSplitPane.getDividerLocation();
        int totalSize = this.m_rootSplitPane.getWidth() - this.m_rootSplitPane.getDividerSize();
        int diff = totalSize - location;
        return diff > 2;
    }

    protected void updatePropPaneViewStatus() {
        if (this.m_rootSplitPane == null) {
            return;
        }
        boolean bShown = this.isPropertyPaneShown();
        if (this.m_viewPropertyBtn != null) {
            this.m_viewPropertyBtn.setSelected(bShown);
        }
        if (this.m_viewPropertiesItem != null) {
            this.m_viewPropertiesItem.setSelected(bShown);
        }
        this.updateSummaryInfoPaneViewStatus();
    }

    private boolean isViewPaneShown() {
        if (this.m_rootSplitPane == null) {
            return true;
        }
        int location = this.m_rootSplitPane.getDividerLocation();
        return location > 2;
    }

    private boolean isSummaryInfoPaneShown() {
        if (this.m_viewSplitPane == null) {
            return false;
        }
        if (this.isViewPaneShown()) {
            int location = this.m_viewSplitPane.getDividerLocation();
            int totalSize = this.m_viewSplitPane.getHeight() - this.m_viewSplitPane.getDividerSize();
            int diff = totalSize - location;
            return diff > 2;
        }
        return false;
    }

    protected void updateSummaryInfoPaneViewStatus() {
        boolean bShown = this.isSummaryInfoPaneShown();
        if (this.m_viewSummaryInfoBtn != null) {
            this.m_viewSummaryInfoBtn.setSelected(bShown);
        }
        if (this.m_viewSummaryInformationItem != null) {
            this.m_viewSummaryInformationItem.setSelected(bShown);
        }
    }

    private void initListeners() {
        this.m_viewPropertyListener = new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                VWTrackerCore.this.performViewProperties(e.getStateChange() == 1);
            }
        };
        this.m_viewSummaryInfoListener = new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                VWTrackerCore.this.performViewSummaryInformation(e.getStateChange() == 1);
            }
        };
        this.m_viewMainToolbarListener = new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                VWTrackerCore.this.performMainToolbarAction(e.getStateChange() == 1, true);
            }
        };
        this.m_viewSubmapToolbarListener = new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                VWTrackerCore.this.performMapToolbarAction(e.getStateChange() == 1, true);
            }
        };
        this.m_viewStatusBarListener = new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                VWTrackerCore.this.performStatusBarAction(e.getStateChange() == 1, true);
            }
        };
        this.m_viewStepNamesListener = new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                VWTrackerCore.this.performViewStepNames(e.getStateChange() == 1);
            }
        };
        this.m_viewRouteNamesListener = new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                VWTrackerCore.this.performViewRouteNames(e.getStateChange() == 1);
            }
        };
        this.m_viewMilestoneListener = new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                VWTrackerCore.this.performViewMilestoneAttrs(e.getStateChange() == 1);
            }
        };
        this.m_viewRouteConditionListener = new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                VWTrackerCore.this.performViewConditionAttrs(e.getStateChange() == 1);
            }
        };
        this.m_viewCollectorListener = new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                VWTrackerCore.this.performViewCollectorAttrs(e.getStateChange() == 1);
            }
        };
        this.m_viewStepStatusListener = new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                VWTrackerCore.this.performViewStepStatus(e.getStateChange() == 1);
            }
        };
        this.m_viewRefreshListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                VWTrackerCore.this.performRefresh();
            }
        };
        this.m_lockStepsListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                VWTrackerCore.this.performLockSelectedSteps();
            }
        };
        this.m_unlockWorkListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                VWTrackerCore.this.performUnlockWork();
            }
        };
        this.m_unlockStepsListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                VWTrackerCore.this.performUnlockSelectedSteps();
            }
        };
        this.m_unlockAllListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                VWTrackerCore.this.performUnlockAll();
            }
        };
        this.m_saveAllListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                VWTrackerCore.this.performSaveAllChanges();
            }
        };
        this.m_cancelAllListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                VWTrackerCore.this.performCancelAllChanges();
            }
        };
        this.m_manageTrackersListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                VWTrackerCore.this.performManageTrackers();
            }
        };
        this.m_assignReassignListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                VWTrackerCore.this.performAssignReassignWork();
            }
        };
        this.m_completeWorkListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                VWTrackerCore.this.performCompleteWork();
            }
        };
        this.m_terminateWorkListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                VWTrackerCore.this.performDeleteWork();
            }
        };
        this.m_launchStepPropcessorListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                VWTrackerCore.this.performLaunchStepProcessor();
            }
        };
        this.m_contextAndIndexListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                VWTrackerCore.this.performContentsAndIndex();
            }
        };
        this.m_aboutListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                VWTrackerCore.this.performAboutItemAction();
            }
        };
        this.m_exitListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                VWTrackerCore.this.performExitItemAction();
            }
        };
        this.m_viewMenuListener = new MenuListener(){

            public void menuSelected(MenuEvent e) {
                if (VWTrackerCore.this.m_bTrackerMode && VWTrackerCore.this.m_viewPropertiesItem != null) {
                    if (VWTrackerCore.this.isPropertyPaneShown()) {
                        VWTrackerCore.this.m_viewPropertiesItem.setSelected(true);
                    } else {
                        VWTrackerCore.this.m_viewPropertiesItem.setSelected(false);
                    }
                }
                if (VWTrackerCore.this.m_viewSummaryInformationItem != null) {
                    if (VWTrackerCore.this.isSummaryInfoPaneShown()) {
                        VWTrackerCore.this.m_viewSummaryInformationItem.setSelected(true);
                    } else {
                        VWTrackerCore.this.m_viewSummaryInformationItem.setSelected(false);
                    }
                }
            }

            public void menuCanceled(MenuEvent e) {
            }

            public void menuDeselected(MenuEvent e) {
            }
        };
        this.m_editPropertiesMenuListener = new MenuListener(){

            public void menuSelected(MenuEvent e) {
                boolean bAltered = VWTrackerCore.this.m_trackerDataModel.isAltered();
                VWTrackerCore.this.m_saveChangesItem.setEnabled(bAltered);
                VWTrackerCore.this.m_cancelChangesItem.setEnabled(bAltered);
            }

            public void menuCanceled(MenuEvent e) {
            }

            public void menuDeselected(MenuEvent e) {
            }
        };
        this.m_taskMenuListener = new MenuListener(){

            public void menuSelected(MenuEvent e) {
                VWTrackerCore.this.m_manageTrackersItem.setEnabled(VWTrackerCore.this.m_trackerDataModel.getCanManageTrackers());
            }

            public void menuCanceled(MenuEvent e) {
            }

            public void menuDeselected(MenuEvent e) {
            }
        };
    }

    private void initMenuBar(JMenuBar menuBar) {
        JMenu settingsMenu;
        this.m_fileMenu = VWStringUtils.getMenuUsingString(VWResource.s_fileMenu_withHK);
        menuBar.add(this.m_fileMenu);
        this.m_exitItem = VWStringUtils.getMenuItemUsingString(VWResource.s_exitMenu_withHK);
        this.m_exitItem.addActionListener(this.m_exitListener);
        this.m_fileMenu.add(this.m_exitItem);
        this.m_viewMenu = VWStringUtils.getMenuUsingString(VWResource.s_viewMenu_withHK);
        menuBar.add(this.m_viewMenu);
        if (this.m_bTrackerMode) {
            this.m_editPropertiesMenu = VWStringUtils.getMenuUsingString(VWResource.s_editPropertiesMenu_withHK);
            menuBar.add(this.m_editPropertiesMenu);
            this.m_lockSelectedStepsItem = VWStringUtils.getMenuItemUsingString(VWResource.s_lockSelectedStepsMenuItem_withHK);
            this.m_lockSelectedStepsItem.addActionListener(this.m_lockStepsListener);
            this.m_editPropertiesMenu.add(this.m_lockSelectedStepsItem);
            this.m_editPropertiesMenu.add(new JSeparator());
            this.m_saveChangesItem = VWStringUtils.getMenuItemUsingString(VWResource.s_saveAllChangesMenuItem_withHK);
            this.m_saveChangesItem.addActionListener(this.m_saveAllListener);
            this.m_editPropertiesMenu.add(this.m_saveChangesItem);
            this.m_cancelChangesItem = VWStringUtils.getMenuItemUsingString(VWResource.s_cancelAllChangesMenuItem_withHK);
            this.m_cancelChangesItem.addActionListener(this.m_cancelAllListener);
            this.m_editPropertiesMenu.add(this.m_cancelChangesItem);
            this.m_editPropertiesMenu.add(new JSeparator());
            this.m_editPropertiesMenu.addMenuListener(this.m_editPropertiesMenuListener);
            this.m_unlockMenu = VWStringUtils.getMenuUsingString(VWResource.s_unlockMenu_withHK);
            this.m_editPropertiesMenu.add(this.m_unlockMenu);
            this.m_unlockItem = VWStringUtils.getMenuItemUsingString(VWResource.s_ellipse.toString(VWResource.s_unlockMenuItem_withHK));
            this.m_unlockItem.addActionListener(this.m_unlockWorkListener);
            this.m_unlockMenu.add(this.m_unlockItem);
            this.m_unlockSelectedItem = VWStringUtils.getMenuItemUsingString(VWResource.s_unlockSelectedStepsMenuItem_withHK);
            this.m_unlockSelectedItem.addActionListener(this.m_unlockStepsListener);
            this.m_unlockMenu.add(this.m_unlockSelectedItem);
            this.m_unlockAllItem = VWStringUtils.getMenuItemUsingString(VWResource.s_unlockAllMenuItem_withHK);
            this.m_unlockAllItem.addActionListener(this.m_unlockAllListener);
            this.m_unlockMenu.add(this.m_unlockAllItem);
            this.m_tasksMenu = VWStringUtils.getMenuUsingString(VWResource.s_tasksMenu_withHK);
            menuBar.add(this.m_tasksMenu);
            this.m_manageTrackersItem = VWStringUtils.getMenuItemUsingString(VWResource.s_ellipse.toString(VWResource.s_manageTrackers_withHK));
            this.m_manageTrackersItem.addActionListener(this.m_manageTrackersListener);
            this.m_tasksMenu.add(this.m_manageTrackersItem);
            this.m_tasksMenu.add(new JSeparator());
            this.m_completeWorkItem = VWStringUtils.getMenuItemUsingString(VWResource.s_ellipse.toString(VWResource.s_completeWorkMenuItem_withHK));
            this.m_completeWorkItem.addActionListener(this.m_completeWorkListener);
            this.m_tasksMenu.add(this.m_completeWorkItem);
            this.m_assignReassignWorkItem = VWStringUtils.getMenuItemUsingString(VWResource.s_ellipse.toString(VWResource.s_assignReassignWorkMenuItem_withHK));
            this.m_assignReassignWorkItem.addActionListener(this.m_assignReassignListener);
            this.m_tasksMenu.add(this.m_assignReassignWorkItem);
            this.m_terminateWorkItem = VWStringUtils.getMenuItemUsingString(VWResource.s_ellipse.toString(VWResource.s_terminateWorkAtAStepMenuItem_withHK));
            this.m_terminateWorkItem.addActionListener(this.m_terminateWorkListener);
            this.m_tasksMenu.add(this.m_terminateWorkItem);
            this.m_tasksMenu.add(new JSeparator());
            this.m_launchStepProcessorItem = VWStringUtils.getMenuItemUsingString(VWResource.s_ellipse.toString(VWResource.s_openWorkItemMenuItem_withHK));
            this.m_launchStepProcessorItem.addActionListener(this.m_launchStepPropcessorListener);
            this.m_tasksMenu.add(this.m_launchStepProcessorItem);
            this.m_tasksMenu.addMenuListener(this.m_taskMenuListener);
        }
        if ((settingsMenu = this.getSettingsMenu(menuBar)) != null) {
            menuBar.add(settingsMenu);
        }
        this.m_helpMenu = VWStringUtils.getMenuUsingString(VWResource.s_helpMenu_withHK);
        menuBar.add(this.m_helpMenu);
        this.m_contentsIndexItem = VWStringUtils.getMenuItemUsingString(VWResource.s_ellipse.toString(VWResource.s_contentsAndIndexMenuItem_withHK));
        this.m_contentsIndexItem.addActionListener(this.m_contextAndIndexListener);
        this.m_helpMenu.add(this.m_contentsIndexItem);
        this.m_helpMenu.add(new JSeparator());
        this.m_aboutItem = VWStringUtils.getMenuItemUsingString(VWResource.s_ellipse.toString(VWResource.s_about_withHK));
        this.m_aboutItem.addActionListener(this.m_aboutListener);
        this.m_helpMenu.add(this.m_aboutItem);
    }

    private void initViewToolBar(JToolBar toolbar) {
        toolbar.setFloatable(false);
        toolbar.setBorderPainted(false);
        this.m_viewSummaryInfoBtn = this.addToolBarButton(toolbar, "vSummary", VWResource.s_viewHistoryToolTip, true, this.m_viewSummaryInfoListener);
        this.m_viewSummaryInfoBtn.setSelected(true);
        if (this.m_bTrackerMode) {
            this.m_viewPropertyBtn = this.addToolBarButton(toolbar, "vProp", VWResource.s_viewPropertiesToolTip, true, this.m_viewPropertyListener);
            this.m_viewPropertyBtn.setSelected(true);
            VWImageLoader.addToolbarSeparator(toolbar);
        }
        this.m_viewRefreshBtn = this.addToolBarButton(toolbar, "refresh", VWResource.s_refresh, false, this.m_viewRefreshListener);
    }

    private void initEditPropToolBar(JToolBar toolbar) {
        if (!this.m_bTrackerMode) {
            return;
        }
        toolbar.setFloatable(false);
        toolbar.setBorderPainted(false);
        this.m_lockStepsBtn = this.addToolBarButton(toolbar, "lock", VWResource.s_lockSelectedSteps, false, this.m_lockStepsListener);
        this.m_unlockStepsBtn = this.addToolBarButton(toolbar, "unlock", VWResource.s_unlockSelectedSteps, false, this.m_unlockStepsListener);
        this.m_unlockAllBtn = this.addToolBarButton(toolbar, "unlock_all", VWResource.s_unlockAll, false, this.m_unlockAllListener);
        this.m_saveAllBtn = this.addToolBarButton(toolbar, "save_all", VWResource.s_saveAllChanges, false, this.m_saveAllListener);
        this.m_cancelAllBtn = this.addToolBarButton(toolbar, "cancel_all", VWResource.s_cancelAllChanges, false, this.m_cancelAllListener);
    }

    private void initHelpToolBar(JToolBar toolbar) {
        toolbar.setFloatable(false);
        toolbar.setBorderPainted(false);
        this.m_contextAndIndexBtn = this.addToolBarButton(toolbar, "help", VWResource.s_help, false, this.m_contextAndIndexListener);
    }

    private void initTaskToolBar(JToolBar toolbar) {
        if (!this.m_bTrackerMode) {
            return;
        }
        toolbar.setFloatable(false);
        toolbar.setBorderPainted(false);
        this.m_manageTrackersBtn = this.addToolBarButton(toolbar, "manage_trackers", VWResource.s_manageTrackers, false, this.m_manageTrackersListener);
        this.m_completeWorkBtn = this.addToolBarButton(toolbar, "compwork", VWResource.s_completeWork, false, this.m_completeWorkListener);
        this.m_assignReassignBtn = this.addToolBarButton(toolbar, "assign_reassign", VWResource.s_assignReassignWork, false, this.m_assignReassignListener);
        this.m_terminateWorkBtn = this.addToolBarButton(toolbar, "delWork", VWResource.s_terminateWorkAtAStep, false, this.m_terminateWorkListener);
        this.m_launchStepPropcessorBtn = this.addToolBarButton(toolbar, "open", VWResource.s_openWorkItem, false, this.m_launchStepPropcessorListener);
    }

    private void initToolBars() {
        this.initViewToolBar(this.m_viewToolBar);
        if (this.m_bTrackerMode) {
            this.initEditPropToolBar(this.m_editPropToolBar);
            this.initTaskToolBar(this.m_taskToolBar);
        }
        this.initHelpToolBar(this.m_helpToolBar);
        this.m_toolbarPanel.setLayout(new BoxLayout(this.m_toolbarPanel, 2));
        this.m_toolbarPanel.setAlignmentX(0.0f);
        this.m_toolbarPanel.add(this.m_viewToolBar);
        VWImageLoader.addToolbarSeparator(this.m_viewToolBar);
        if (this.m_bTrackerMode) {
            this.m_toolbarPanel.add(this.m_editPropToolBar);
            VWImageLoader.addToolbarSeparator(this.m_editPropToolBar);
            this.m_toolbarPanel.add(this.m_taskToolBar);
            VWImageLoader.addToolbarSeparator(this.m_taskToolBar);
        }
        this.m_toolbarPanel.add(this.m_helpToolBar);
    }

    private AbstractButton addToolBarButton(JToolBar toolbar, String name, String toolTip, boolean bUseToggleButton, EventListener listener) {
        AbstractButton button = VWImageLoader.createToolBarButton(name + ".gif", toolTip, bUseToggleButton);
        if (button != null) {
            toolbar.add(button);
            button.setRolloverEnabled(true);
            if (listener instanceof ActionListener) {
                button.addActionListener((ActionListener)listener);
            } else if (listener instanceof ItemListener) {
                button.addItemListener((ItemListener)listener);
            }
        }
        return button;
    }

    private void initStatusBar() {
        try {
            this.m_statusBar = new JPanel();
            this.m_statusBar.setBorder(BorderFactory.createLoweredBevelBorder());
            this.m_statusBar.setLayout(new GridBagLayout());
            GridBagConstraints gbCons = new GridBagConstraints();
            gbCons.gridx = 0;
            gbCons.gridy = 0;
            gbCons.weightx = 1.0;
            gbCons.weighty = 0.0;
            gbCons.gridheight = 1;
            gbCons.gridwidth = 1;
            gbCons.insets = new Insets(0, 0, 0, 0);
            gbCons.anchor = 21;
            gbCons.fill = 1;
            this.m_msgLabel = new JLabel();
            this.m_statusBar.add((Component)this.m_msgLabel, gbCons);
            ++gbCons.gridx;
            gbCons.gridy = 0;
            gbCons.weightx = 0.0;
            gbCons.weighty = 0.0;
            gbCons.gridheight = 1;
            gbCons.gridwidth = 1;
            gbCons.insets = new Insets(0, 0, 0, 0);
            gbCons.anchor = 22;
            gbCons.fill = 1;
            this.m_stepNamesCheckBox = new JCheckBox(VWImageLoader.createImageIcon("step_hide.gif"));
            this.m_stepNamesCheckBox.setSelectedIcon(VWImageLoader.createImageIcon("step_show.gif"));
            this.m_stepNamesCheckBox.setToolTipText(VWResource.s_showHideStepNamesStr);
            this.m_stepNamesCheckBox.setSelected(true);
            this.m_stepNamesCheckBox.addItemListener(this.m_viewStepNamesListener);
            this.m_statusBar.add((Component)this.m_stepNamesCheckBox, gbCons);
            ++gbCons.gridx;
            gbCons.gridy = 0;
            gbCons.weightx = 0.0;
            gbCons.weighty = 0.0;
            gbCons.gridheight = 1;
            gbCons.gridwidth = 1;
            gbCons.insets = new Insets(0, 0, 0, 0);
            gbCons.anchor = 22;
            gbCons.fill = 1;
            this.m_routeNamesCheckBox = new JCheckBox(VWImageLoader.createImageIcon("route_hide.gif"));
            this.m_routeNamesCheckBox.setSelectedIcon(VWImageLoader.createImageIcon("route_show.gif"));
            this.m_routeNamesCheckBox.setToolTipText(VWResource.s_showHideRouteNamesStr);
            this.m_routeNamesCheckBox.setSelected(true);
            this.m_routeNamesCheckBox.addItemListener(this.m_viewRouteNamesListener);
            this.m_statusBar.add((Component)this.m_routeNamesCheckBox, gbCons);
            ++gbCons.gridx;
            gbCons.gridy = 0;
            gbCons.weightx = 0.0;
            gbCons.weighty = 0.0;
            gbCons.gridheight = 1;
            gbCons.gridwidth = 1;
            gbCons.insets = new Insets(0, 0, 0, 0);
            gbCons.anchor = 22;
            gbCons.fill = 1;
            this.m_milestoneAttrsCheckBox = new JCheckBox(VWImageLoader.createImageIcon("milestone_hide.gif"));
            this.m_milestoneAttrsCheckBox.setSelectedIcon(VWImageLoader.createImageIcon("milestone_show.gif"));
            this.m_milestoneAttrsCheckBox.setToolTipText(VWResource.s_showHideMilestoneAttributesStr);
            this.m_milestoneAttrsCheckBox.setSelected(true);
            this.m_milestoneAttrsCheckBox.addItemListener(this.m_viewMilestoneListener);
            this.m_statusBar.add((Component)this.m_milestoneAttrsCheckBox, gbCons);
            ++gbCons.gridx;
            gbCons.gridy = 0;
            gbCons.weightx = 0.0;
            gbCons.weighty = 0.0;
            gbCons.gridheight = 1;
            gbCons.gridwidth = 1;
            gbCons.insets = new Insets(0, 0, 0, 0);
            gbCons.anchor = 22;
            gbCons.fill = 1;
            this.m_conditionAttrsCheckBox = new JCheckBox(VWImageLoader.createImageIcon("condition_hide.gif"));
            this.m_conditionAttrsCheckBox.setSelectedIcon(VWImageLoader.createImageIcon("condition_show.gif"));
            this.m_conditionAttrsCheckBox.setToolTipText(VWResource.s_showHideConditionAttributesStr);
            this.m_conditionAttrsCheckBox.setSelected(true);
            this.m_conditionAttrsCheckBox.addItemListener(this.m_viewRouteConditionListener);
            this.m_statusBar.add((Component)this.m_conditionAttrsCheckBox, gbCons);
            ++gbCons.gridx;
            gbCons.gridy = 0;
            gbCons.weightx = 0.0;
            gbCons.weighty = 0.0;
            gbCons.gridheight = 1;
            gbCons.gridwidth = 1;
            gbCons.insets = new Insets(0, 0, 0, 0);
            gbCons.anchor = 22;
            gbCons.fill = 1;
            this.m_collectorAttrsCheckBox = new JCheckBox(VWImageLoader.createImageIcon("collector_hide.gif"));
            this.m_collectorAttrsCheckBox.setSelectedIcon(VWImageLoader.createImageIcon("collector_show.gif"));
            this.m_collectorAttrsCheckBox.setToolTipText(VWResource.s_showHideCollectorAttributesStr);
            this.m_collectorAttrsCheckBox.setSelected(true);
            this.m_collectorAttrsCheckBox.addItemListener(this.m_viewCollectorListener);
            this.m_statusBar.add((Component)this.m_collectorAttrsCheckBox, gbCons);
            ++gbCons.gridx;
            gbCons.gridy = 0;
            gbCons.weightx = 0.0;
            gbCons.weighty = 0.0;
            gbCons.gridheight = 1;
            gbCons.gridwidth = 1;
            gbCons.insets = new Insets(0, 0, 0, 0);
            gbCons.anchor = 22;
            gbCons.fill = 1;
            this.m_stepStatusCheckBox = new JCheckBox(VWImageLoader.createImageIcon("status_hide.gif"));
            this.m_stepStatusCheckBox.setSelectedIcon(VWImageLoader.createImageIcon("status_show.gif"));
            this.m_stepStatusCheckBox.setToolTipText(VWResource.s_showHideStepStatusStr);
            this.m_stepStatusCheckBox.setSelected(true);
            this.m_stepStatusCheckBox.addItemListener(this.m_viewStepStatusListener);
            this.m_statusBar.add((Component)this.m_stepStatusCheckBox, gbCons);
            this.m_contentPane.add((Component)this.m_statusBar, "Last");
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void windowActivated(WindowEvent e) {
    }

    public void windowClosed(WindowEvent e) {
    }

    public void windowClosing(WindowEvent e) {
        this.exitApplication();
    }

    public void windowDeactivated(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowOpened(WindowEvent e) {
    }

    public void itemStateChanged(ItemEvent event) {
        Object obj = event.getItem();
        if (obj == null) {
            return;
        }
        if (obj instanceof VWTrkStep) {
            int[] stepIds = new int[]{((VWTrkStep)obj).getStepId()};
            this.m_trackerWorkflowPane.selectSteps(stepIds);
        } else if (obj instanceof VWTrkMap) {
            String mapName = ((VWTrkMap)obj).getMapName();
            if (mapName != null) {
                this.m_trackerWorkflowPane.selectMap(mapName);
            }
        } else if (obj instanceof String && event.getSource() == this.m_summaryPane) {
            this.m_trackerWorkflowPane.selectMap((String)obj);
        }
    }

    protected void performExitItemAction() {
        this.exitApplication();
    }

    protected void performViewProperties(boolean bView) {
        if (!this.m_bTrackerMode) {
            return;
        }
        boolean bChanged = false;
        if (bView) {
            if (!this.isPropertyPaneShown()) {
                if (this.m_hLastLoc > this.m_rootSplitPane.getMaximumDividerLocation()) {
                    this.m_hLastLoc = this.m_rootSplitPane.getMaximumDividerLocation();
                }
                this.m_rootSplitPane.setDividerLocation(this.m_hLastLoc);
                bChanged = true;
            }
        } else if (this.isPropertyPaneShown()) {
            this.m_hLastLoc = this.m_rootSplitPane.getDividerLocation();
            this.m_rootSplitPane.setDividerLocation(1.0);
            bChanged = true;
        }
        if (bChanged) {
            boolean bShown = this.isPropertyPaneShown();
            if (this.m_viewPropertyBtn != null) {
                this.m_viewPropertyBtn.setSelected(bShown);
            }
            if (this.m_viewPropertiesItem != null) {
                this.m_viewPropertiesItem.setSelected(bShown);
            }
        }
    }

    protected void performViewSummaryInformation(boolean bView) {
        boolean bChanged = false;
        if (bView) {
            if (!this.isSummaryInfoPaneShown()) {
                if (!this.isViewPaneShown()) {
                    if (this.m_hLastLoc < this.m_rootSplitPane.getMinimumDividerLocation()) {
                        this.m_hLastLoc = this.m_rootSplitPane.getMinimumDividerLocation();
                    }
                    this.m_rootSplitPane.setDividerLocation(this.m_hLastLoc);
                    bChanged = true;
                }
                if (!this.isSummaryInfoPaneShown()) {
                    if (this.m_vLastLoc > this.m_viewSplitPane.getMaximumDividerLocation()) {
                        this.m_vLastLoc = this.m_viewSplitPane.getMaximumDividerLocation();
                    }
                    this.m_viewSplitPane.setDividerLocation(this.m_vLastLoc);
                    bChanged = true;
                }
            }
        } else if (this.isSummaryInfoPaneShown()) {
            this.m_vLastLoc = this.m_viewSplitPane.getDividerLocation();
            this.m_viewSplitPane.setDividerLocation(1.0);
            bChanged = true;
        }
        if (bChanged) {
            boolean bShown = this.isSummaryInfoPaneShown();
            if (this.m_viewSummaryInformationItem != null) {
                this.m_viewSummaryInformationItem.setSelected(bShown);
            }
            if (this.m_viewSummaryInfoBtn != null) {
                this.m_viewSummaryInfoBtn.setSelected(bShown);
            }
        }
    }

    protected void performViewStepNames(boolean bView) {
        this.m_trackerWorkflowPane.getMapAttributes().setStepNameVisible(bView);
    }

    protected void performViewRouteNames(boolean bView) {
        this.m_trackerWorkflowPane.getMapAttributes().setRouteNameVisible(bView);
    }

    protected void performViewStepStatus(boolean bView) {
        this.m_trackerWorkflowPane.setStepStatusVisible(bView);
    }

    protected void performRefresh() {
        if (this.m_bPerformingTask) {
            return;
        }
        try {
            this.m_bPerformingTask = true;
            boolean bCanceled = false;
            boolean bSave = false;
            if (this.m_trackerDataModel.isAltered()) {
                VWConfirmRefreshDialog confirmRefreshDialog = new VWConfirmRefreshDialog(this.m_parentFrame);
                confirmRefreshDialog.setVisible(true);
                bCanceled = confirmRefreshDialog.isCanceled();
                if (!bCanceled) {
                    bSave = confirmRefreshDialog.isYes();
                }
            }
            if (!bCanceled) {
                this.m_trackerDataModel.refresh(bSave);
            }
        }
        catch (Exception e) {
            this.logShowException(e, VWResource.s_refresh);
        }
        this.m_bPerformingTask = false;
    }

    void refresh() {
        if (this.m_bRefreshing) {
            return;
        }
        try {
            this.m_bRefreshing = true;
            int option = JOptionPane.showConfirmDialog(this.m_parentFrame, VWResource.s_dataModifiedOutsideScope, VWIDMBaseFactory.instance().getVWString(6).toString(), 0, 3, null);
            if (option == 0) {
                this.performRefresh();
            }
        }
        catch (Exception ex) {
            this.logShowException(ex, VWResource.s_refresh);
        }
        this.m_bRefreshing = false;
    }

    protected void performLockSelectedSteps() {
        if (!this.m_bTrackerMode) {
            return;
        }
        if (this.m_bPerformingTask) {
            return;
        }
        try {
            this.m_bPerformingTask = true;
            Vector steps = new Vector();
            Object[] objects = this.m_trackerWorkflowPane.getSelectedObjects();
            VWLockWork lockWork = null;
            try {
                if (objects != null && objects.length > 0) {
                    lockWork = new VWLockWork(this.m_parentFrame, this.m_trackerDataModel, objects);
                }
            }
            catch (Exception ex) {
                VWDebug.logException(ex);
                JOptionPane.showMessageDialog(this.m_parentFrame, ex.getLocalizedMessage(), filenet.vw.toolkit.runtime.resources.VWResource.s_lock, 1, null);
            }
        }
        catch (Exception ex) {
            this.logShowException(ex, VWResource.s_lock);
        }
        this.m_bPerformingTask = false;
    }

    protected void performSaveAllChanges() {
        if (!this.m_bTrackerMode) {
            return;
        }
        if (this.m_bPerformingTask) {
            return;
        }
        try {
            this.m_bPerformingTask = true;
            this.m_trackerDataModel.saveAllChanges();
        }
        catch (VWException ex) {
            this.logShowException(ex, VWResource.s_saveAllChanges);
        }
        this.m_bPerformingTask = false;
    }

    protected void performCancelAllChanges() {
        if (!this.m_bTrackerMode) {
            return;
        }
        if (this.m_bPerformingTask) {
            return;
        }
        try {
            this.m_bPerformingTask = true;
            VWConfirmCancelChangesDialog dialog = new VWConfirmCancelChangesDialog(this.m_parentFrame);
            dialog.setVisible(true);
            if (!dialog.isCanceled()) {
                this.m_trackerDataModel.disgardChanges();
            }
        }
        catch (Exception ex) {
            this.logShowException(ex, VWResource.s_cancelAllChanges);
        }
        this.m_bPerformingTask = false;
    }

    protected void performUnlockWork() {
        if (!this.m_bTrackerMode) {
            return;
        }
        if (this.m_bPerformingTask) {
            return;
        }
        try {
            this.m_bPerformingTask = true;
            Frame parent = this.m_parentFrame;
            if (this.m_mainContainer instanceof JApplet && !((JApplet)this.m_mainContainer).isActive()) {
                parent = null;
            }
            VWUnlockWorkDialog dlg = null;
            dlg = new VWUnlockWorkDialog(parent, this.m_trackerDataModel);
            if (dlg != null) {
                dlg.setVisible(true);
                dlg.removeReferences();
            }
        }
        catch (Exception ex) {
            this.logShowException(ex, VWResource.s_unlock);
        }
        this.m_bPerformingTask = false;
    }

    protected void performUnlockSelectedSteps() {
        if (!this.m_bTrackerMode) {
            return;
        }
        if (this.m_bPerformingTask) {
            return;
        }
        try {
            this.m_bPerformingTask = true;
            Vector steps = new Vector();
            Object[] objects = this.m_trackerWorkflowPane.getSelectedObjects();
            VWUnlockWork unlockWork = null;
            try {
                unlockWork = new VWUnlockWork(this.m_parentFrame, this.m_trackerDataModel, objects);
                if (unlockWork != null && unlockWork.isAnyParticipant()) {
                    unlockWork.unlockWork();
                    if (!unlockWork.isCanceled() && !unlockWork.isUnlocked()) {
                        JOptionPane.showMessageDialog(this.m_parentFrame, VWResource.s_someWorkCannotUnlock, VWResource.s_unlockSelectedSteps, 1, null);
                    }
                }
            }
            catch (Exception ex) {
                VWDebug.logException(ex);
                JOptionPane.showMessageDialog(this.m_parentFrame, ex.getLocalizedMessage(), VWResource.s_unlock, 1, null);
            }
        }
        catch (Exception ex) {
            this.logShowException(ex, VWResource.s_unlock);
        }
        this.m_bPerformingTask = false;
    }

    protected void performUnlockAll() {
        if (!this.m_bTrackerMode) {
            return;
        }
        if (this.m_bPerformingTask) {
            return;
        }
        try {
            this.m_bPerformingTask = true;
            VWUnlockWork unlockWork = null;
            try {
                unlockWork = new VWUnlockWork(this.m_parentFrame, this.m_trackerDataModel);
                try {
                    if (unlockWork != null && unlockWork.isAnyParticipant()) {
                        unlockWork.unlockWork();
                        if (!unlockWork.isCanceled() && !unlockWork.isUnlocked()) {
                            JOptionPane.showMessageDialog(this.m_parentFrame, VWResource.s_someWorkCannotUnlock, VWResource.s_unlockAll, 1, null);
                        }
                    }
                }
                catch (Exception ex) {
                    this.logShowException(ex, VWResource.s_unlock);
                }
            }
            catch (Exception ex) {
                VWDebug.logException(ex);
                JOptionPane.showMessageDialog(this.m_parentFrame, ex.getLocalizedMessage(), VWResource.s_unlock, 1, null);
            }
        }
        catch (Exception ex) {
            this.logShowException(ex, VWResource.s_unlock);
        }
        this.m_bPerformingTask = false;
    }

    private void performMainToolbarAction(boolean bShow, boolean bNotify) {
        if (this.m_viewMainToolbarItem != null && this.m_viewMainToolbarItem.isSelected() != bShow) {
            this.m_viewMainToolbarItem.setSelected(bShow);
        }
        if (this.m_toolbarPanel.isVisible() != bShow) {
            this.m_toolbarPanel.setVisible(bShow);
            if (bNotify) {
                this.m_toolbarActionNotifier.notifyToolbarAction(this, bShow ? 600 : 601);
            }
        }
    }

    private void performMapToolbarAction(boolean bShow, boolean bNotify) {
        if (this.m_viewSubmapToolbarItem != null && this.m_viewSubmapToolbarItem.isSelected() != bShow) {
            this.m_viewSubmapToolbarItem.setSelected(bShow);
        }
        if (this.m_trackerWorkflowPane.getMapToolbar().isVisible() != bShow) {
            this.m_trackerWorkflowPane.getMapToolbar().setVisible(bShow);
            if (bNotify) {
                this.m_toolbarActionNotifier.notifyToolbarAction(this, bShow ? 602 : 603);
            }
        }
    }

    private void performViewMilestoneAttrs(boolean bShow) {
        this.m_trackerWorkflowPane.getMapAttributes().setMilestoneVisible(bShow);
    }

    private void performViewConditionAttrs(boolean bShow) {
        this.m_trackerWorkflowPane.getMapAttributes().setConditionAttrsVisible(bShow);
    }

    private void performViewCollectorAttrs(boolean bShow) {
        this.m_trackerWorkflowPane.getMapAttributes().setCollectorAttrsVisible(bShow);
    }

    private void performStatusBarAction(boolean bShow, boolean bNotify) {
        if (this.m_viewStatusBarItem != null && this.m_viewStatusBarItem.isSelected() != bShow) {
            this.m_viewStatusBarItem.setSelected(bShow);
        }
        if (this.m_statusBar.isVisible() != bShow) {
            this.m_statusBar.setVisible(bShow);
            if (bNotify) {
                this.m_toolbarActionNotifier.notifyToolbarAction(this, bShow ? 604 : 605);
            }
        }
    }

    protected void performManageTrackers() {
        if (!this.m_bTrackerMode || !this.m_trackerDataModel.getCanManageTrackers()) {
            return;
        }
        if (this.m_bPerformingTask) {
            return;
        }
        try {
            this.m_bPerformingTask = true;
            VWManageTrackersDialog dlg = new VWManageTrackersDialog(this.m_parentFrame, this.m_trackerDataModel);
            dlg.setVisible(true);
            if (!dlg.isCanceled()) {
                try {
                    this.m_trackerDataModel.refreshTrackerList();
                }
                catch (VWException ex) {
                    this.logShowException(ex, VWResource.s_refreshListOfTrackers);
                }
            }
        }
        catch (Exception ex) {
            this.logShowException(ex, VWResource.s_manageTrackers);
        }
        this.m_bPerformingTask = false;
    }

    protected void performAssignReassignWork() {
        if (!this.m_bTrackerMode) {
            return;
        }
        if (this.m_bPerformingTask) {
            return;
        }
        try {
            this.m_bPerformingTask = true;
            VWAssignWorkDialog dlg = new VWAssignWorkDialog(this.m_parentFrame, this.m_trackerDataModel);
            if (dlg.isCanReassignWork()) {
                dlg.setVisible(true);
            } else {
                JOptionPane.showMessageDialog(this.m_parentFrame, VWResource.s_noWorkCanBeReassigned, VWResource.s_assignWorkDialogTitle, -1, null);
            }
        }
        catch (Exception ex) {
            this.logShowException(ex, VWResource.s_assignWorkDialogTitle);
        }
        this.m_bPerformingTask = false;
    }

    protected void performCompleteWork() {
        if (!this.m_bTrackerMode) {
            return;
        }
        if (this.m_bPerformingTask) {
            return;
        }
        try {
            this.m_bPerformingTask = true;
            VWCompleteWorkDialog dlg = new VWCompleteWorkDialog(this.m_parentFrame, this.m_trackerDataModel);
            if (dlg.isAnyActiveWork()) {
                dlg.setVisible(true);
            } else {
                JOptionPane.showMessageDialog(this.m_parentFrame, VWResource.s_noActiveStepsInWorkflow, VWResource.s_completeWorkDialogTitle, -1, null);
            }
        }
        catch (Exception ex) {
            this.logShowException(ex, VWResource.s_completeWorkDialogTitle);
        }
        this.m_bPerformingTask = false;
    }

    protected void performDeleteWork() {
        if (!this.m_bTrackerMode) {
            return;
        }
        if (this.m_bPerformingTask) {
            return;
        }
        try {
            this.m_bPerformingTask = true;
            VWDeleteWorkDialog dlg = new VWDeleteWorkDialog(this.m_parentFrame, this.m_trackerDataModel);
            if (dlg.isAnyActiveWork()) {
                dlg.setVisible(true);
            } else {
                JOptionPane.showMessageDialog(this.m_parentFrame, VWResource.s_noActiveStepsInWorkflow, VWResource.s_terminateWorkDialogTitle, -1, null);
            }
        }
        catch (Exception ex) {
            this.logShowException(ex, VWResource.s_terminateWorkDialogTitle);
        }
        this.m_bPerformingTask = false;
    }

    protected void performReturnWork() {
        if (!this.m_bTrackerMode) {
            return;
        }
        if (this.m_bPerformingTask) {
            return;
        }
        try {
            this.m_bPerformingTask = true;
            VWReturnWorkDialog dlg = new VWReturnWorkDialog(this.m_parentFrame, this.m_trackerDataModel);
            if (dlg.isCanReturnWork()) {
                dlg.setVisible(true);
            } else {
                JOptionPane.showMessageDialog(this.m_parentFrame, VWResource.s_noWorkCanBeReturned, VWResource.s_returnWorkDialogTitle, -1, null);
            }
        }
        catch (Exception ex) {
            this.logShowException(ex, VWResource.s_returnWorkDialogTitle);
        }
        this.m_bPerformingTask = false;
    }

    protected void performLaunchStepProcessor() {
        if (!this.m_bTrackerMode) {
            return;
        }
        if (this.m_bPerformingTask) {
            return;
        }
        try {
            this.m_bPerformingTask = true;
            VWLaunchStepProcessorDialog dlg = new VWLaunchStepProcessorDialog(this.m_parentApplet, this.m_parentFrame, this.m_mainContainer, this.m_trackerDataModel);
            if (dlg.isAnyActiveWork()) {
                dlg.setVisible(true);
            } else {
                JOptionPane.showMessageDialog(this.m_parentFrame, VWResource.s_noActiveStepsInWorkflow, VWResource.s_openWorkItemDialogTitle, -1, null);
            }
        }
        catch (Exception ex) {
            this.logShowException(ex, VWResource.s_openWorkItemDialogTitle);
        }
        this.m_bPerformingTask = false;
    }

    protected void performContentsAndIndex() {
        VWHelp.displayPage(VWHelp.Help_Process_Tracker + "bpfpt023.htm");
    }

    protected void performAboutItemAction() {
        try {
            ImageIcon icon = VWImageLoader.createImageIcon("tracker.gif");
            String productName = VWIDMBaseFactory.instance().getVWString(6).toString();
            VWAboutHelper aboutBox = new VWAboutHelper(this.m_parentFrame, productName, icon, this.m_vwSessionInfo);
            aboutBox.display();
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void exitApplication() {
        if (this.m_mainContainer != null && this.m_mainContainer instanceof JFrame) {
            JFrame frame = (JFrame)this.m_mainContainer;
            this.doExit();
            Toolkit.getDefaultToolkit().getSystemEventQueue().postEvent(new WindowEvent(frame, 201));
        } else if (this.m_mainContainer != null && this.m_mainContainer instanceof VWBaseAppLauncherApplet) {
            VWBaseAppLauncherApplet applet = (VWBaseAppLauncherApplet)this.m_mainContainer;
            this.doExit();
            applet.closeWindow();
        }
    }

    void doExit() {
        block8: {
            try {
                int option;
                if (!this.m_bTrackerMode || this.m_trackerDataModel == null) break block8;
                Frame parent = this.m_parentFrame;
                if (this.m_mainContainer instanceof JApplet && !((JApplet)this.m_mainContainer).isActive()) {
                    parent = null;
                }
                if (this.m_trackerDataModel.isLockedByCurrentUser() && (option = JOptionPane.showConfirmDialog(parent, VWResource.s_exitAndUnlock, VWIDMBaseFactory.instance().getVWString(6).toString(), 0, 3, null)) == 0) {
                    this.performUnlockWork();
                }
                if (this.m_trackerDataModel.isAltered() && (option = JOptionPane.showConfirmDialog(parent, VWResource.s_exitAndSave, VWIDMBaseFactory.instance().getVWString(6).toString(), 0, 3, null)) == 0) {
                    try {
                        this.m_trackerDataModel.saveAllChanges();
                    }
                    catch (VWException ex) {
                        VWDebug.logException(ex);
                        String title = VWIDMBaseFactory.instance().getVWString(6).toString();
                        if (parent == null) {
                            title = title + " - " + VWResource.s_saveAllChanges;
                        }
                        JOptionPane.showMessageDialog(parent, ex.getLocalizedMessage(), title, 0, null);
                    }
                }
                this.cleanup();
                System.runFinalization();
                System.gc();
                System.runFinalization();
            }
            catch (Exception ex) {
                VWDebug.logException(ex);
            }
        }
    }

    private void calcHSplitRatio() {
        if (!this.m_bTrackerMode) {
            return;
        }
        double ratio = 0.0;
        Dimension dim = this.m_rootSplitPane.getSize();
        int loc = this.m_rootSplitPane.getDividerLocation();
        int totalWidth = dim.width - this.m_rootSplitPane.getDividerSize();
        if (totalWidth > 0 && (ratio = (double)loc / (double)totalWidth) >= 0.0 && ratio <= 1.0) {
            this.m_hSplitRatio = ratio;
        }
    }

    private void calcVSplitRatio() {
        int loc;
        if (!this.m_bInitialized) {
            return;
        }
        if (this.m_bTrackerMode && (loc = this.m_rootSplitPane.getDividerLocation()) == 0) {
            return;
        }
        double ratio = 0.0;
        Dimension summaryDim = this.m_summaryPane.getSize();
        Dimension mapDim = this.m_trackerWorkflowPane.getSize();
        int totalHeight = summaryDim.height + mapDim.height;
        if (totalHeight > 0 && (ratio = (double)mapDim.height / (double)totalHeight) >= 0.0 && ratio <= 1.0) {
            this.m_vSplitRatio = ratio;
        }
    }

    public void toolbarActionPerformed(VWToolbarActionEvent event) {
        if (event.getSource() == this) {
            return;
        }
        int id = event.getID();
        switch (id) {
            case 600: {
                this.performMainToolbarAction(true, false);
                break;
            }
            case 601: {
                this.performMainToolbarAction(false, false);
                break;
            }
            case 602: {
                this.performMapToolbarAction(true, false);
                break;
            }
            case 603: {
                this.performMapToolbarAction(false, false);
                break;
            }
            case 604: {
                this.performStatusBarAction(true, false);
                break;
            }
            case 605: {
                this.performStatusBarAction(false, false);
            }
        }
    }

    public void propertyChange(VWPropertyChangeEvent event) {
        Object obj = event.getSource();
        if (obj instanceof IVWPropertyChangeSource) {
            IVWPropertyChangeSource source = (IVWPropertyChangeSource)obj;
            int type = event.getID();
            switch (type) {
                case 709: {
                    if (!this.m_trackerDataModel.getNeedRefresh() || this.m_bIsRefreshing) break;
                    this.m_bIsRefreshing = true;
                    this.refresh();
                    this.m_trackerDataModel.setNeedRefresh(false);
                    this.m_bIsRefreshing = false;
                }
            }
        }
    }

    private void logShowException(Exception ex, String title) {
        VWDebug.logException(ex);
        String msg = ex.getLocalizedMessage();
        if (msg == null || msg.length() == 0) {
            msg = ex.getClass().getName();
        }
        JOptionPane.showMessageDialog(this.m_parentFrame, msg, title, 0, null);
    }

    public Frame getParentFrame() {
        return this.m_parentFrame;
    }

    private void cleanup() {
        VWPropertyChangeNotifier.removePropertyChangeListener(this);
        if (this.m_toolbarActionNotifier != null) {
            this.m_toolbarActionNotifier.removeToolbarActionListener(this);
            this.m_toolbarActionNotifier = null;
        }
        this.m_splashWindow = null;
        if (this.m_fileMenu != null) {
            this.m_fileMenu.removeAll();
            this.m_fileMenu = null;
        }
        if (this.m_viewMenu != null) {
            this.m_viewMenu.removeMenuListener(this.m_viewMenuListener);
            this.m_viewMenu.removeAll();
            this.m_viewMenu = null;
        }
        this.m_viewMenuListener = null;
        if (this.m_viewPropertiesItem != null) {
            this.m_viewPropertiesItem.removeItemListener(this.m_viewPropertyListener);
            this.m_viewPropertiesItem = null;
        }
        if (this.m_viewSummaryInformationItem != null) {
            this.m_viewSummaryInformationItem.removeItemListener(this);
            this.m_viewSummaryInformationItem.removeItemListener(this.m_viewSummaryInfoListener);
            this.m_viewSummaryInformationItem = null;
        }
        if (this.m_toolbarMenu != null) {
            this.m_toolbarMenu.removeAll();
            this.m_toolbarMenu = null;
        }
        if (this.m_exitItem != null) {
            this.m_exitItem.removeActionListener(this.m_exitListener);
            this.m_exitItem = null;
        }
        if (this.m_viewMainToolbarItem != null) {
            this.m_viewMainToolbarItem.removeItemListener(this.m_viewMainToolbarListener);
            this.m_viewMainToolbarItem = null;
        }
        if (this.m_viewSubmapToolbarItem != null) {
            this.m_viewSubmapToolbarItem.removeItemListener(this.m_viewSubmapToolbarListener);
            this.m_viewSubmapToolbarItem = null;
        }
        if (this.m_viewStatusBarItem != null) {
            this.m_viewStatusBarItem.removeItemListener(this.m_viewStatusBarListener);
            this.m_viewStatusBarItem = null;
        }
        if (this.m_refreshItem != null) {
            this.m_refreshItem.removeActionListener(this.m_viewRefreshListener);
            this.m_refreshItem = null;
        }
        if (this.m_editPropertiesMenu != null) {
            this.m_editPropertiesMenu.removeMenuListener(this.m_editPropertiesMenuListener);
            this.m_editPropertiesMenu.removeAll();
            this.m_editPropertiesMenu = null;
        }
        if (this.m_lockSelectedStepsItem != null) {
            this.m_lockSelectedStepsItem.removeActionListener(this.m_lockStepsListener);
            this.m_lockSelectedStepsItem = null;
        }
        if (this.m_saveChangesItem != null) {
            this.m_saveChangesItem.removeActionListener(this.m_saveAllListener);
            this.m_saveChangesItem = null;
        }
        if (this.m_cancelChangesItem != null) {
            this.m_cancelChangesItem.removeActionListener(this.m_cancelAllListener);
            this.m_cancelChangesItem = null;
        }
        if (this.m_unlockMenu != null) {
            this.m_unlockMenu.removeAll();
            this.m_unlockMenu = null;
        }
        if (this.m_unlockItem != null) {
            this.m_unlockItem.removeActionListener(this.m_unlockWorkListener);
            this.m_unlockItem = null;
        }
        if (this.m_unlockSelectedItem != null) {
            this.m_unlockSelectedItem.removeActionListener(this.m_unlockStepsListener);
            this.m_unlockSelectedItem = null;
        }
        if (this.m_unlockAllItem != null) {
            this.m_unlockAllItem.removeActionListener(this.m_unlockAllListener);
            this.m_unlockAllItem = null;
        }
        if (this.m_tasksMenu != null) {
            this.m_tasksMenu.removeMenuListener(this.m_taskMenuListener);
            this.m_tasksMenu.removeAll();
            this.m_tasksMenu = null;
        }
        this.m_taskMenuListener = null;
        if (this.m_manageTrackersItem != null) {
            this.m_manageTrackersItem.removeActionListener(this.m_manageTrackersListener);
            this.m_manageTrackersItem = null;
        }
        if (this.m_assignReassignWorkItem != null) {
            this.m_assignReassignWorkItem.removeActionListener(this.m_assignReassignListener);
            this.m_assignReassignWorkItem = null;
        }
        if (this.m_completeWorkItem != null) {
            this.m_completeWorkItem.removeActionListener(this.m_completeWorkListener);
            this.m_completeWorkItem = null;
        }
        if (this.m_terminateWorkItem != null) {
            this.m_terminateWorkItem.removeActionListener(this.m_terminateWorkListener);
            this.m_terminateWorkItem = null;
        }
        if (this.m_launchStepProcessorItem != null) {
            this.m_launchStepProcessorItem.removeActionListener(this.m_launchStepPropcessorListener);
            this.m_launchStepProcessorItem = null;
        }
        if (this.m_helpMenu != null) {
            this.m_helpMenu.removeAll();
            this.m_helpMenu = null;
        }
        if (this.m_contentsIndexItem != null) {
            this.m_contentsIndexItem.removeActionListener(this.m_contextAndIndexListener);
            this.m_contentsIndexItem = null;
        }
        if (this.m_aboutItem != null) {
            this.m_aboutItem.removeActionListener(this.m_aboutListener);
            this.m_aboutItem = null;
        }
        if (this.m_statusBar != null) {
            this.m_statusBar.removeMouseListener(this.m_statusBarMouseListener);
            this.m_statusBar.removeAll();
            this.m_statusBar = null;
        }
        if (this.m_statusBarMouseListener != null) {
            this.m_statusBarMouseListener.removeReferences();
            this.m_statusBarMouseListener = null;
        }
        if (this.m_mainContainer != null && !(this.m_mainContainer instanceof VWBaseAppLauncherApplet)) {
            if (this.m_rootPane != null) {
                this.m_rootPane.removeAll();
            }
            if (this.m_contentPane != null) {
                this.m_contentPane.removeAll();
            }
            if (this.m_mainContainer != null) {
                this.m_mainContainer.removeAll();
            }
        }
        this.m_rootPane = null;
        this.m_contentPane = null;
        this.m_mainContainer = null;
        this.m_parentApplet = null;
        this.m_applet = null;
        this.m_bFrame = false;
        this.m_vwSessionInfo = null;
        if (this.m_toolbarPanel != null) {
            this.m_toolbarPanel.removeMouseListener(this.m_toolbarMouseListener);
            this.m_toolbarPanel.removeAll();
            this.m_toolbarPanel = null;
        }
        if (this.m_toolbarMouseListener != null) {
            this.m_toolbarMouseListener.removeReferences();
        }
        if (this.m_toolbar != null) {
            this.m_toolbar.removeAll();
            this.m_toolbar = null;
        }
        if (this.m_viewToolBar != null) {
            this.m_viewToolBar.removeAll();
            this.m_viewToolBar = null;
        }
        if (this.m_viewPropertyBtn != null) {
            this.m_viewPropertyBtn.removeItemListener(this.m_viewPropertyListener);
            this.m_viewPropertyBtn = null;
        }
        if (this.m_viewSummaryInfoBtn != null) {
            this.m_viewSummaryInfoBtn.removeItemListener(this.m_viewSummaryInfoListener);
            this.m_viewSummaryInfoBtn = null;
        }
        if (this.m_viewRefreshBtn != null) {
            this.m_viewRefreshBtn.removeActionListener(this.m_viewRefreshListener);
            this.m_viewRefreshBtn = null;
        }
        if (this.m_editPropToolBar != null) {
            this.m_editPropToolBar.removeAll();
            this.m_editPropToolBar = null;
        }
        if (this.m_lockStepsBtn != null) {
            this.m_lockStepsBtn.removeActionListener(this.m_lockStepsListener);
            this.m_lockStepsBtn = null;
        }
        if (this.m_unlockStepsBtn != null) {
            this.m_unlockStepsBtn.removeActionListener(this.m_unlockStepsListener);
            this.m_unlockStepsBtn = null;
        }
        if (this.m_unlockAllBtn != null) {
            this.m_unlockAllBtn.removeActionListener(this.m_unlockAllListener);
            this.m_unlockAllBtn = null;
        }
        if (this.m_saveAllBtn != null) {
            this.m_saveAllBtn.removeActionListener(this.m_saveAllListener);
            this.m_saveAllBtn = null;
        }
        if (this.m_cancelAllBtn != null) {
            this.m_cancelAllBtn.removeActionListener(this.m_cancelAllListener);
            this.m_cancelAllBtn = null;
        }
        if (this.m_taskToolBar != null) {
            this.m_taskToolBar.removeAll();
            this.m_taskToolBar = null;
        }
        if (this.m_manageTrackersBtn != null) {
            this.m_manageTrackersBtn.removeActionListener(this.m_manageTrackersListener);
            this.m_manageTrackersBtn = null;
        }
        if (this.m_assignReassignBtn != null) {
            this.m_assignReassignBtn.removeActionListener(this.m_assignReassignListener);
            this.m_assignReassignBtn = null;
        }
        if (this.m_completeWorkBtn != null) {
            this.m_completeWorkBtn.removeActionListener(this.m_completeWorkListener);
            this.m_completeWorkBtn = null;
        }
        if (this.m_terminateWorkBtn != null) {
            this.m_terminateWorkBtn.removeActionListener(this.m_terminateWorkListener);
            this.m_terminateWorkBtn = null;
        }
        if (this.m_launchStepPropcessorBtn != null) {
            this.m_launchStepPropcessorBtn.removeActionListener(this.m_launchStepPropcessorListener);
            this.m_launchStepPropcessorBtn = null;
        }
        if (this.m_helpToolBar != null) {
            this.m_helpToolBar.removeAll();
            this.m_helpToolBar = null;
        }
        if (this.m_contextAndIndexBtn != null) {
            this.m_contextAndIndexBtn.removeActionListener(this.m_contextAndIndexListener);
            this.m_contextAndIndexBtn = null;
        }
        if (this.m_aboutBtn != null) {
            this.m_aboutBtn.removeActionListener(this.m_aboutListener);
            this.m_aboutBtn = null;
        }
        if (this.m_menuBar != null) {
            this.m_menuBar.removeAll();
            this.m_menuBar = null;
        }
        this.m_viewMenuListener = null;
        this.m_viewPropertyListener = null;
        this.m_viewSummaryInfoListener = null;
        this.m_viewRefreshListener = null;
        this.m_viewMainToolbarListener = null;
        this.m_viewSubmapToolbarListener = null;
        this.m_viewStatusBarListener = null;
        this.m_editPropertiesMenuListener = null;
        this.m_unlockWorkListener = null;
        this.m_lockStepsListener = null;
        this.m_unlockStepsListener = null;
        this.m_unlockAllListener = null;
        this.m_saveAllListener = null;
        this.m_cancelAllListener = null;
        this.m_taskMenuListener = null;
        this.m_manageTrackersListener = null;
        this.m_assignReassignListener = null;
        this.m_completeWorkListener = null;
        this.m_terminateWorkListener = null;
        this.m_launchStepPropcessorListener = null;
        this.m_contextAndIndexListener = null;
        this.m_aboutListener = null;
        this.m_exitListener = null;
        this.m_toolbarMouseListener = null;
        if (this.m_collectorAttrsCheckBox != null) {
            this.m_collectorAttrsCheckBox.addItemListener(this.m_viewCollectorListener);
            this.m_collectorAttrsCheckBox = null;
            this.m_viewCollectorListener = null;
        }
        if (this.m_stepStatusCheckBox != null) {
            this.m_stepStatusCheckBox.addItemListener(this.m_viewStepStatusListener);
            this.m_stepStatusCheckBox = null;
            this.m_viewStepStatusListener = null;
        }
        if (this.m_stepNamesCheckBox != null) {
            this.m_stepNamesCheckBox.addItemListener(this.m_viewStepNamesListener);
            this.m_stepNamesCheckBox = null;
            this.m_viewStepNamesListener = null;
        }
        if (this.m_routeNamesCheckBox != null) {
            this.m_routeNamesCheckBox.addItemListener(this.m_viewRouteNamesListener);
            this.m_routeNamesCheckBox = null;
            this.m_viewRouteNamesListener = null;
        }
        if (this.m_milestoneAttrsCheckBox != null) {
            this.m_milestoneAttrsCheckBox.addItemListener(this.m_viewMilestoneListener);
            this.m_milestoneAttrsCheckBox = null;
            this.m_viewMilestoneListener = null;
        }
        if (this.m_conditionAttrsCheckBox != null) {
            this.m_conditionAttrsCheckBox.addItemListener(this.m_viewRouteConditionListener);
            this.m_conditionAttrsCheckBox = null;
            this.m_viewRouteConditionListener = null;
        }
        this.m_sync = null;
        this.m_vwStepElement = null;
        this.m_workflowDefinition = null;
        if (this.m_mainPanel != null) {
            this.m_mainPanel.removeAll();
            this.m_mainPanel = null;
        }
        if (this.m_rootSplitPane != null) {
            this.m_rootSplitPane.removeAll();
            this.m_rootSplitPane = null;
        }
        if (this.m_viewSplitPane != null) {
            this.m_viewSplitPane.removeAll();
            this.m_viewSplitPane = null;
        }
        if (this.m_bTrackerMode) {
            this.m_trackerWorkflowPane.removeItemListener(this.m_propPane);
            this.m_propPane.removeItemListener(this.m_trackerWorkflowPane);
            this.m_propPane.removeItemListener(this.m_summaryPane);
        }
        if (this.m_trackerDataModel != null) {
            this.m_trackerWorkflowPane.removeItemListener(this.m_trackerDataModel);
            this.m_trackerDataModel.cleanup();
            this.m_trackerDataModel = null;
        }
        this.m_summaryPane.removeItemListener(this);
        if (this.m_trackerWorkflowPane != null) {
            this.m_trackerWorkflowPane.removeItemListener(this.m_summaryPane);
            this.m_trackerWorkflowPane.removeReferences();
            this.m_trackerWorkflowPane = null;
        }
        if (this.m_summaryPane != null) {
            this.m_summaryPane.removeReferences();
            this.m_summaryPane = null;
        }
        if (this.m_propPane != null) {
            this.m_propPane.removeReferences();
            this.m_propPane = null;
        }
        if (this.m_parentFrame != null) {
            if (this.m_parentFrame instanceof VWBaseLaunchableApplication) {
                this.m_parentFrame.dispose();
            }
            this.m_parentFrame = null;
        }
        this.m_initThread = null;
        this.m_msgLabel = null;
    }

    class ViewSplitPane
    extends JSplitPane {
        boolean m_bInitialized = false;
        VWTrackerCore m_trackerCore = null;

        ViewSplitPane(VWTrackerCore core) {
            this.m_trackerCore = core;
        }

        public void setInitialized(boolean initialized) {
            this.m_bInitialized = initialized;
        }

        public void setDividerLocation(int location) {
            super.setDividerLocation(location);
            if (this.m_bInitialized) {
                this.m_trackerCore.updateSummaryInfoPaneViewStatus();
            }
        }

        public void setLastDividerLocation(int location) {
            super.setLastDividerLocation(location);
            if (this.m_bInitialized) {
                this.m_trackerCore.updateSummaryInfoPaneViewStatus();
            }
        }

        public void setBounds(int x, int y, int width, int height) {
            super.setBounds(x, y, width, height);
            this.setDividerLocation(VWTrackerCore.this.m_vSplitRatio);
        }
    }

    class RootSplitPane
    extends JSplitPane {
        boolean m_bInitialized = false;
        VWTrackerCore m_trackerCore = null;

        RootSplitPane(VWTrackerCore core) {
            this.m_trackerCore = core;
        }

        public void setInitialized(boolean initialized) {
            this.m_bInitialized = initialized;
        }

        public void setDividerLocation(int location) {
            if (this.m_bInitialized) {
                this.m_trackerCore.calcVSplitRatio();
            }
            super.setDividerLocation(location);
            if (this.m_bInitialized) {
                this.m_trackerCore.updatePropPaneViewStatus();
            }
        }

        public void setLastDividerLocation(int location) {
            super.setLastDividerLocation(location);
            if (this.m_bInitialized) {
                this.m_trackerCore.updatePropPaneViewStatus();
            }
        }

        public void setBounds(int x, int y, int width, int height) {
            if (this.m_bInitialized) {
                this.m_trackerCore.calcHSplitRatio();
                this.m_trackerCore.calcVSplitRatio();
            }
            super.setBounds(x, y, width, height);
            this.setDividerLocation(VWTrackerCore.this.m_hSplitRatio);
        }
    }
}

